<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Flash Messages -->
            <?php if ($this->session->flashdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('warning')): ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('warning'); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <div class="text-center mb-4">
                        <i class="fas fa-calendar-check fa-3x text-primary mb-3"></i>
                        <h2 class="fw-bold">Book Your Free Consultation</h2>
                        <p class="lead text-muted">Get expert guidance tailored to your needs</p>
                    </div>
                    
                    <?php echo form_open('consultation/submit', array('id' => 'consultationForm')); ?>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="full_name" class="form-label fw-bold">Full Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="full_name" name="full_name" 
                                       value="<?php echo set_value('full_name'); ?>" required>
                                <?php echo form_error('full_name', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label fw-bold">Email Address <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="email" name="email" 
                                       value="<?php echo set_value('email'); ?>" required>
                                <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label fw-bold">Phone Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" id="phone" name="phone" 
                                       value="<?php echo set_value('phone'); ?>" required>
                                <?php echo form_error('phone', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="organization" class="form-label fw-bold">Organization <small class="text-muted">(Optional)</small></label>
                                <input type="text" class="form-control" id="organization" name="organization" 
                                       value="<?php echo set_value('organization'); ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="consultation_type" class="form-label fw-bold">Consultation Type <span class="text-danger">*</span></label>
                            <select class="form-select" id="consultation_type" name="consultation_type" required>
                                <option value="">-- Select Type --</option>
                                <option value="general" <?php echo set_select('consultation_type', 'general'); ?>>General Inquiry</option>
                                <option value="program" <?php echo set_select('consultation_type', 'program'); ?>>Program Information</option>
                                <option value="volunteer" <?php echo set_select('consultation_type', 'volunteer'); ?>>Volunteering</option>
                                <option value="partnership" <?php echo set_select('consultation_type', 'partnership'); ?>>Partnership Opportunity</option>
                                <option value="other" <?php echo set_select('consultation_type', 'other'); ?>>Other</option>
                            </select>
                            <?php echo form_error('consultation_type', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="preferred_date" class="form-label fw-bold">Preferred Date</label>
                                <input type="date" class="form-control" id="preferred_date" name="preferred_date" 
                                       value="<?php echo set_value('preferred_date'); ?>" min="<?php echo date('Y-m-d'); ?>">
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="preferred_time" class="form-label fw-bold">Preferred Time</label>
                                <select class="form-select" id="preferred_time" name="preferred_time">
                                    <option value="">-- Select Time --</option>
                                    <option value="morning" <?php echo set_select('preferred_time', 'morning'); ?>>Morning (9 AM - 12 PM)</option>
                                    <option value="afternoon" <?php echo set_select('preferred_time', 'afternoon'); ?>>Afternoon (12 PM - 3 PM)</option>
                                    <option value="evening" <?php echo set_select('preferred_time', 'evening'); ?>>Evening (3 PM - 6 PM)</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="subject" class="form-label fw-bold">Subject <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="subject" name="subject" 
                                   value="<?php echo set_value('subject'); ?>" required>
                            <?php echo form_error('subject', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        
                        <div class="mb-3">
                            <label for="message" class="form-label fw-bold">Message <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="message" name="message" rows="5" required><?php echo set_value('message'); ?></textarea>
                            <?php echo form_error('message', '<small class="text-danger">', '</small>'); ?>
                            <small class="form-text text-muted">Tell us how we can help you</small>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-paper-plane"></i> Submit Request
                            </button>
                        </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
            
            <div class="text-center mt-4">
                <p class="text-muted">We typically respond within 24-48 hours</p>
            </div>
        </div>
    </div>
</div>